import re
import sys

with open(sys.argv[1], 'r') as f:
    script = f.read()

#Retirer tous les tags
expression = r"(([A-Z]{2,})(\s|_)*([A-Z]+)*)+"
script = re.sub(expression, r'', script, flags=re.M)

#je commence par retirer tous les numéros, ponctuations, espaces en début de ligne :
expression = r"[0-9]*\s*: "
script = re.sub(expression, r'', script, flags=re.M)

#SUPPRIMER LES _ qui restent après suppression des majuscules.
expression = r"_"
script = re.sub(expression,r'', script, flags=re.M)

#Ensuite je sépare les répliques selon les phrases en conservant la ponctuation :
expression = r"(\.|\?|\!|\.\.\.)(\s)(?=[A-Z])"
script = re.sub(expression, r'\1\n', script, flags=re.M)

#Je supprime les espaces et les \ en trop
script = re.sub(r"\\", '', script, flags=re.M)

# puis les lignes vides
expression = r'\n(?=\n+)'
script = re.sub(expression, '', script, flags=re.M)

#Sauvegarde
with open(sys.argv[2], 'w') as fi:
    fi.write(script)
